*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Fenamiphos                                           *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";
libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";
/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data fenamiphos;
     set epa.fenamiphos;
run;
proc sort data=fenamiphos;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Fenamiphos - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Fenamiphos);
ods rtf close;



*===> Human vs. Rat;

title "Human vs. Rat: model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=fenamiphos /*itdetails*/ method=firo tech=newrap lis=3 maxiter=20000;
      PARMS ha=0.28
            hb=0.20     
            ra=0.35
            rb=0.22     
            gha=0.11    ghab=-.14         ghb=-.59
            gra=.58     grab=1.0    grb=.17
            S2E=0.1207;

            rha=ha+uha;
            rra=ra+ura;
            rhb=hb+uhb;
            rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-2 + H_I__M + rrb*Rat*1e-2 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],  [gha*1e-3, 
                                                                                     ghab*1e-2, ghb*1e-3,
                                                                                    0,            0,   gra*1e-2,
                                                                                    0,       0,   grab*1e-2, grb*1e-1]) SUBJECT=ID out=RandID_HR; 
        ESTIMATE "human/rat" (ha/hb)/(ra/rb);
        ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	   predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Fenamiphos human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=Fenamiphos, model=3)
ods rtf close;
%Calculate_Ki(chemical=Fenamiphos, Hadj=1e-2, Radj=1e-2);



*===> Adult vs. Infant;

title "Final Model 3 - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=fenamiphos(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.29	adB=2.09
			ia=.27 iB=1.66
			gada=.020 	gadab=.073 	gadb=2.79
			gia=-.0019 	giab=-.07 	gib=-.19
			S2E=0.03652;

          	rada=ada+uada;
			radb=adB+uadb;
			ria=ia+uia;
           	rib=iB+uib;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*1e-3*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uada uadb uia uib ~ normal([0, 0, 0, 0],   [gada*1e-1, 
														gadab*1e-1, gadb*1e-1, 
														0,    0,     gia*1e-1, 
														0,    0,     giab*1e-1,   gib*1e-1]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Fenamiphos Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=Fenamiphos, model=3);
ods rtf close;



*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=fenamiphos(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.2771 mb= 1.9996
			fa=.2921 fB=1.9777
			gha=.01517 	ghab=0.05332	ghb=2.0134
			S2E=.03680;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-3 + H_I__M*male + rfb*female*1e-3 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-1]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Fenamiphos Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=Fenamiphos, model=2);
ods rtf close;


*===> Caucasian vs. Other races;

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=fenamiphos(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=.2812	cB=1.8887
			ora=.2983 orB=2.2896
			gha=.01449	ghab=0.02235	ghb=0.1514
			S2E=.03714;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-3 + H_I__M*caucasian + rorb*otherrace*1e-3 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb]) SUBJECT=ID out=RandID_CO;
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Fenamiphos Caucasian-Other.rtf" startpage=no;
%DiagnosticsCO(chemical=Fenamiphos, model=2);
ods rtf close;


